<?php
session_start(); // Sāk sesiju, lai varētu izmantot sesijas mainīgos

// Ja lietotājs nav pieteicies, novirzām viņu uz pieteikšanās lapu
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit(); 
}

// Datu bāzes savienojuma informācija
$servername = "localhost";  
$username = "root";         
$password = "";             
$dbname = "eraecho";        

// Izveido savienojumu ar datu bāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbaudām, vai savienojums ir veiksmīgs
if ($conn->connect_error) {
    echo json_encode(['message' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

// Iegūstam lietotāja ID no sesijas
$user_id = $_SESSION['user_id']; 

// SQL vaicājums, lai iegūtu visus groza vienumus attiecīgajam lietotājam
$sql = "SELECT ci.id, ci.quantity, ci.price, p.name, p.image_url 
        FROM cart_items ci 
        JOIN products p ON ci.product_id = p.id
        JOIN carts c ON ci.cart_id = c.id 
        WHERE c.user_id = ?";
$stmt = $conn->prepare($sql); // Sagatavojam SQL vaicājumu
$stmt->bind_param("i", $user_id); // Saistām lietotāja ID ar SQL vaicājumu
$stmt->execute(); // Izpildām vaicājumu
$result = $stmt->get_result(); // Iegūstam rezultātu no vaicājuma

// Inicializējam mainīgos, lai aprēķinātu kopsavilkumu
$subtotal = 0; // Apakškopējā cena
$cart_items = []; // Groza vienumu saraksts

// Iegūstam visus groza vienumus un aprēķinām apakškopējo cenu
while ($row = $result->fetch_assoc()) {
    $cart_items[] = $row; // Pievienojam katru vienumu masīvam
    $subtotal += $row['quantity'] * $row['price']; // Aprēķinām apakškopējo cenu
}

$stmt->close(); // Aizveram sagatavoto vaicājumu
$conn->close(); // Aizveram datu bāzes savienojumu
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Cart - Era Echo</title>
  <link rel="stylesheet" href="css/styles.css">
  <link rel="icon" href="img/favicon.ico">
  <style>
    /* Inline styles for cart page */
    .cart-container {
      width: 90%;
      max-width: 1200px;
      margin: 50px auto;
    }

    .cart-header {
      font-size: 24px;
      font-weight: bold;
      margin-bottom: 20px;
      text-align: center;
    }

    .cart-items {
      margin-bottom: 30px;
    }

    .cart-item {
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 10px;
      border-bottom: 1px solid #ddd;
    }

    .cart-item img {
      width: 80px;
      height: 80px;
      object-fit: cover;
      border-radius: 8px;
    }

    .cart-item-details {
      flex: 1;
      margin-left: 20px;
    }

    .cart-item-details h4 {
      font-size: 18px;
      margin-bottom: 5px;
    }

    .cart-item-details p {
      margin: 0;
      color: #666;
    }

    .cart-summary {
      margin: 30px 0;
      padding: 20px;
      background-color: #f8f8f8;
      border-radius: 8px;
      text-align: center;
    }

    .cart-summary p {
      font-size: 18px;
      margin: 10px 0;
    }

    .checkout-form {
      display: flex;
      flex-direction: column;
      gap: 15px;
    }

    .checkout-form input,
    .checkout-form button {
      padding: 10px;
      font-size: 16px;
      border: 1px solid #ddd;
      border-radius: 4px;
    }

    .checkout-form button {
      background-color: #111;
      color: #fff;
      cursor: pointer;
      transition: background-color 0.3s ease;
    }

    .checkout-form button:hover {
      background-color: #333;
    }
  </style>
</head>
<body>

<header class="header"> 
    <div class="container"> 
      <div class="logo"><a href="homepage.html">ERA ECHO</a></div> 
      <nav class="nav">
        <div class="dropdown">
          <span class="dropdown-label">Collections</span>
          <div class="dropdown-content">
            <a href="tops.html">Tops</a>
            <a href="bottoms.html">Bottoms</a>
            <a href="knitwear.html">Knitwear</a>
            <a href="outerwear.html">Outerwear</a>
            <a href="denim.html">Denim</a>
            <a href="suiting.html">Suiting</a>
            <a href="footwear.html">Footwear</a>
            <a href="accessories.html">Accessories</a>
            <a href="shop-all.html">Shop All</a>
          </div>
        </div>
        <a href="php/logout.php" class="logout-button">Logout</a> <!-- Izlogoties -->
        <a href="about.html">About</a>
        <a href="user-info.html">User</a>
      </nav>
    </div>
</header>

<div class="cart-container">
  <h1 class="cart-header">Your Cart</h1>

  <div class="cart-items">
    <!-- Ja grozs ir tukšs, parādām ziņojumu -->
    <?php if (empty($cart_items)): ?>
      <p>Your cart is empty.</p>
    <?php else: ?>
      <!-- Cikls, lai izdrukātu katru vienumu grozā -->
      <?php foreach ($cart_items as $item): ?>
        <div class="cart-item">
          <img src="<?php echo $item['image_url']; ?>" alt="<?php echo $item['name']; ?>">
          <div class="cart-item-details">
            <h4><?php echo $item['name']; ?></h4>
            <p>Size: M</p> <!-- Pieņēmums, ka izmērs ir "M", bet tas var būt dinamisks -->
            <p>Price: $<?php echo number_format($item['price'], 2); ?></p>
          </div>
          <p>Quantity: <?php echo $item['quantity']; ?></p> <!-- Parāda preces daudzumu -->
        </div>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>

  <div class="cart-summary">
    <!-- Parāda kopsavilkuma datus (apakškopējums, nodoklis, kopējā summa) -->
    <p>Subtotal: $<?php echo number_format($subtotal, 2); ?></p>
    <p>Tax: $<?php echo number_format($subtotal * 0.08, 2); ?></p> <!-- Aprēķina 8% nodokli -->
    <p><strong>Total: $<?php echo number_format($subtotal * 1.08, 2); ?></strong></p> <!-- Kopējā summa ar nodokli -->
  </div>

  <!-- Pasūtījuma apstrādes forma -->
  <form class="checkout-form" action="process-order.php" method="POST">
    <input type="text" name="name" placeholder="Full Name" required>
    <input type="email" name="email" placeholder="Email Address" required>
    <input type="text" name="address" placeholder="Shipping Address" required>
    <input type="tel" name="phone" placeholder="Phone Number" required>
    <button type="submit">Proceed to Payment</button> <!-- Sagatavo pirkumu apmaksai -->
  </form>
</div>

<footer class="footer">
  <div class="container">
    <p>&copy; 2024 Era Echo. All rights reserved.</p> <!-- Autortiesību paziņojums -->
  </div>
</footer>

</body>
</html>
